/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.outline;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.Messages;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommonQuickOutlinePage
extends ContentOutlinePage {
    private static final int FILTER_REFRESH_DELAY = 200;
    private static final int REFRESH_DELAY = 500;
    private Composite _composite;
    private AbstractThemeableEditor _editor;
    private PatternFilter _filter;
    private String _pattern;
    private WorkbenchJob _filterRefreshJob;
    private WorkbenchJob _delayedRefreshJob;
    private Text _searchBox;
    private TreeViewer _treeViewer;
    private IDocumentListener _documentListener;
    private ToolBarManager _toolbarManager;

    public CommonQuickOutlinePage(AbstractThemeableEditor editor) {
        this._editor = editor;
    }

    private Composite createComposite(Composite parent) {
        GridLayoutFactory factory = GridLayoutFactory.fillDefaults().spacing(0, 0);
        Composite result = new Composite(parent, 0);
        factory.applyTo(result);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        this._composite = this.createComposite(parent);
        this._treeViewer = this.createTreeViewer(this._composite);
        Tree tree = this._treeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    CommonQuickOutlinePage.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CommonQuickOutlinePage.this.gotoSelectedElement();
            }
        });
        this._filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                boolean result = true;
                String label = null;
                if (element instanceof CommonOutlineItem) {
                    label = ((CommonOutlineItem)element).getLabel();
                } else if (element instanceof IParseNode) {
                    label = ((IParseNode)element).getText();
                }
                if (label != null) {
                    result = this.wordMatches(label);
                }
                return result;
            }
        };
        this._filter.setIncludeLeadingWildcard(true);
        this._treeViewer.addFilter((ViewerFilter)this._filter);
        this._filterRefreshJob = this.createRefreshJob();
        EclipseUtil.setSystemForJob((Job)this._filterRefreshJob);
        this._delayedRefreshJob = this.createDelayedRefreshJob();
        EclipseUtil.setSystemForJob((Job)this._delayedRefreshJob);
        this.createDocumentListener();
        IDocument document = this.getDocument();
        if (document != null) {
            document.addDocumentListener(this._documentListener);
        }
        this.refresh();
    }

    void revealPosition(int documentPos) {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.getTreeViewer().getContentProvider();
        Object[] originalElements = provider.getElements(this._treeViewer.getInput());
        if (originalElements == null || originalElements.length == 0) {
            return;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        final IdentityHashMap<Object, List<Object>> parents = new IdentityHashMap<Object, List<Object>>();
        Object[] objectArray = originalElements;
        int n = originalElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            elements.add(el);
            ++n2;
        }
        if (provider instanceof ITreeContentProvider) {
            ITreeContentProvider treeContentProvider = (ITreeContentProvider)provider;
            Object[] objectArray2 = originalElements;
            int n3 = originalElements.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray2[n];
                this.expandElement(element, treeContentProvider, elements, parents);
                ++n;
            }
        }
        Object bestElement = null;
        int bestElementStartingOffset = -1;
        int bestElementEndingOffset = -1;
        for (Object e : elements) {
            int start = -1;
            int end = -1;
            if (e instanceof IParseNode) {
                IParseNode node = (IParseNode)e;
                start = node.getStartingOffset();
                end = node.getEndingOffset();
            } else if (e instanceof CommonOutlineItem) {
                int refNodeStart = ((CommonOutlineItem)e).getReferenceNode().getStartingOffset();
                int refNodeEnd = ((CommonOutlineItem)e).getReferenceNode().getEndingOffset();
                int elementStart = ((CommonOutlineItem)e).getStartingOffset();
                int elementEnd = ((CommonOutlineItem)e).getEndingOffset();
                start = refNodeStart < elementStart ? refNodeStart : elementStart;
                int n3 = end = refNodeEnd > elementEnd ? refNodeEnd : elementEnd;
            }
            if (start == -1 || start > documentPos || end < documentPos || bestElement != null && bestElementEndingOffset - bestElementStartingOffset <= end - start) continue;
            bestElement = e;
            bestElementStartingOffset = start;
            bestElementEndingOffset = end;
        }
        final Object var9_10 = bestElement;
        WorkbenchJob job = new WorkbenchJob("Initial reveal"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (CommonQuickOutlinePage.this._treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    CommonQuickOutlinePage.this._treeViewer.getControl().setRedraw(false);
                    CommonQuickOutlinePage.this._treeViewer.refresh(true);
                    ArrayList<Object> path = new ArrayList<Object>();
                    List p = (List)parents.get(var9_10);
                    if (p != null) {
                        path.addAll(p);
                    }
                    path.add(var9_10);
                    TreePath treePath = new TreePath(path.toArray());
                    CommonQuickOutlinePage.this._treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
                }
                finally {
                    CommonQuickOutlinePage.this._treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        if (bestElement != null) {
            job.schedule(200L);
        }
    }

    private WorkbenchJob createDelayedRefreshJob() {
        return new WorkbenchJob("Refresh Content"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (CommonQuickOutlinePage.this._treeViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    CommonQuickOutlinePage.this._treeViewer.setSelection(null);
                    CommonQuickOutlinePage.this._treeViewer.refresh();
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private synchronized void createDocumentListener() {
        if (this._documentListener == null) {
            this._documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (CommonQuickOutlinePage.this._delayedRefreshJob != null) {
                        CommonQuickOutlinePage.this._delayedRefreshJob.cancel();
                        CommonQuickOutlinePage.this._delayedRefreshJob.schedule(500L);
                    }
                }
            };
        }
    }

    private WorkbenchJob createRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (CommonQuickOutlinePage.this._treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (CommonQuickOutlinePage.this._pattern == null) {
                    return Status.OK_STATUS;
                }
                CommonQuickOutlinePage.this._filter.setPattern(CommonQuickOutlinePage.this._pattern);
                try {
                    CommonQuickOutlinePage.this._treeViewer.getControl().setRedraw(false);
                    CommonQuickOutlinePage.this._treeViewer.refresh(true);
                    if (CommonQuickOutlinePage.this._pattern.length() > 0) {
                        IStructuredContentProvider provider = (IStructuredContentProvider)CommonQuickOutlinePage.this._treeViewer.getContentProvider();
                        Object[] elements = provider.getElements(CommonQuickOutlinePage.this._treeViewer.getInput());
                        int i = 0;
                        while (i < elements.length) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            CommonQuickOutlinePage.this._treeViewer.expandToLevel(elements[i], -1);
                            ++i;
                        }
                        TreeItem[] items = CommonQuickOutlinePage.this._treeViewer.getTree().getItems();
                        if (items.length > 0) {
                            CommonQuickOutlinePage.this._treeViewer.getTree().showItem(items[0]);
                        }
                    }
                }
                finally {
                    CommonQuickOutlinePage.this._treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    Composite createSearchArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).extendedMargins(0, 0, 3, 0).applyTo(top);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite result = new Composite(top, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(3).applyTo(result);
        GridDataFactory.fillDefaults().align(1, 4).grab(true, false).applyTo((Control)result);
        this._searchBox = new Text(result, 4);
        this._searchBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this._searchBox.setEditable(true);
        this._searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonQuickOutlinePage.this.textChanged();
            }
        });
        this._searchBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    CommonQuickOutlinePage.this._treeViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        ToolBar filtersToolBar = new ToolBar(result, 256);
        filtersToolBar.setLayoutData((Object)new GridData(4, 4, false, true));
        this._toolbarManager = new ToolBarManager(filtersToolBar);
        this._toolbarManager.update(false);
        this._toolbarManager.getControl().update();
        return result;
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = new TreeViewer(new Tree(parent, 772));
        Tree tree = result.getTree();
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        result.setLabelProvider((IBaseLabelProvider)this._editor.getOutlineLabelProvider());
        result.setContentProvider((IContentProvider)this._editor.getOutlineContentProvider());
        result.setInput((Object)this._editor);
        result.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                boolean result = false;
                if (a instanceof CommonOutlineItem && b instanceof CommonOutlineItem) {
                    CommonOutlineItem item1 = (CommonOutlineItem)a;
                    CommonOutlineItem item2 = (CommonOutlineItem)b;
                    result = item1.equals(item2);
                } else if (a instanceof IParseNode && b instanceof IParseNode) {
                    if (a == b) {
                        result = true;
                    } else {
                        IParseNode node1 = (IParseNode)a;
                        IParseNode node2 = (IParseNode)b;
                        result = node1.equals(node2);
                    }
                } else {
                    result = a == b;
                }
                return result;
            }

            public int hashCode(Object element) {
                return 0;
            }
        });
        return result;
    }

    public void dispose() {
        if (this._documentListener != null) {
            IDocument document = this.getDocument();
            if (document != null) {
                document.removeDocumentListener(this._documentListener);
            }
            this._documentListener = null;
        }
        if (this._delayedRefreshJob != null) {
            this._delayedRefreshJob.cancel();
            this._delayedRefreshJob = null;
        }
        if (this._filterRefreshJob != null) {
            this._filterRefreshJob.cancel();
            this._filterRefreshJob = null;
        }
        if (this._toolbarManager != null) {
            this._toolbarManager.dispose();
            this._toolbarManager = null;
        }
        super.dispose();
    }

    private IDocument getDocument() {
        return this._editor.getDocumentProvider().getDocument((Object)this._editor.getEditorInput());
    }

    public Control getControl() {
        return this._composite;
    }

    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    private void refresh() {
        if (!this._treeViewer.getControl().isDisposed()) {
            this._treeViewer.refresh();
        }
    }

    void contributeToQuickOutlineMenu(IMenuManager manager) {
        Action sortAction = new Action(Messages.CommonQuickOutlinePage_SortAlphabetically, 2){

            public void run() {
                CommonQuickOutlinePage.this.getTreeViewer().getControl().setVisible(false);
                if (this.isChecked()) {
                    CommonQuickOutlinePage.this.getTreeViewer().setComparator(new ViewerComparator());
                } else {
                    CommonQuickOutlinePage.this.getTreeViewer().setComparator(null);
                }
                CommonQuickOutlinePage.this.getTreeViewer().getControl().setVisible(true);
            }
        };
        sortAction.setImageDescriptor(UIUtils.getImageDescriptor((String)"com.aptana.editor.common", (String)"icons/sort.gif"));
        sortAction.setToolTipText(Messages.CommonQuickOutlinePage_SortAlphabetically);
        manager.add((IContributionItem)new ActionContributionItem((IAction)sortAction));
        Action collapseAction = new Action(Messages.CommonQuickOutlinePage_CollapseAll, 1){

            public void run() {
                CommonQuickOutlinePage.this.getTreeViewer().collapseAll();
            }
        };
        collapseAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        collapseAction.setToolTipText(Messages.CommonQuickOutlinePage_CollapseAll);
        manager.add((IContributionItem)new ActionContributionItem((IAction)collapseAction));
        Action expandAction = new Action(Messages.CommonQuickOutlinePage_ExpandAll){

            public void run() {
                CommonQuickOutlinePage.this.getTreeViewer().expandAll();
            }
        };
        expandAction.setImageDescriptor(UIUtils.getImageDescriptor((String)"com.aptana.editor.common", (String)"icons/expandall.gif"));
        expandAction.setToolTipText(Messages.CommonQuickOutlinePage_ExpandAll);
        manager.add((IContributionItem)new ActionContributionItem((IAction)expandAction));
    }

    public void setFocus() {
        this._treeViewer.getControl().setFocus();
    }

    Control getSearchBox() {
        return this._searchBox;
    }

    private void textChanged() {
        this._filterRefreshJob.cancel();
        this._filterRefreshJob.schedule(200L);
        this._pattern = this._searchBox.getText();
        this._filter.setPattern(this._pattern);
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getTreeViewer().getSelection();
    }

    private void gotoSelectedElement() {
        IStructuredSelection structured;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            Object element = structured.getFirstElement();
            if (element instanceof CommonOutlineItem) {
                CommonOutlineItem item = (CommonOutlineItem)element;
                this._editor.selectAndReveal(item.getStartingOffset(), item.getLength());
                this.closeDialog();
            } else if (element instanceof IParseNode) {
                int position = ((IParseNode)element).getStartingOffset();
                this._editor.selectAndReveal(position, 0);
                this.closeDialog();
            }
            return;
        }
        this._editor.getISourceViewer().removeRangeIndication();
    }

    private void closeDialog() {
        this.getControl().getParent().getShell().dispose();
    }

    private void expandElement(Object element, ITreeContentProvider treeContentProvider, List<Object> elements, Map<Object, List<Object>> parents) {
        Object child;
        Object[] children = treeContentProvider.getChildren(element);
        List<Object> elementParentsList = parents.get(element);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = objectArray[n2];
            elements.add(child);
            ArrayList<Object> parentsList = new ArrayList<Object>();
            if (elementParentsList != null) {
                parentsList.addAll(elementParentsList);
            }
            parentsList.add(element);
            parents.put(child, parentsList);
            ++n2;
        }
        objectArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            child = objectArray[n2];
            this.expandElement(child, treeContentProvider, elements, parents);
            ++n2;
        }
    }
}

